### 概述

本实验模拟用 MetaFacture IDE 实现了工智机与 EIP 设备 SANGE ELEC 之间的通讯，Sange Elec 仅支持Ethernet IP 协议通讯。

下载：🧷**[MetaFacture与Ethernet IP](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/attachments/Ethernet_IP.zip "Ethernet_IP.zip")**

---

### 软硬件配置

硬件：工智机 SX20 EIP 设备 Sange Elec

软件：MetaFacture 1.0.4.0 EIP 经济型 IO 配置软件 V1.0

硬件连接示意图

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/67162685828bd.png)

---

### 操作步骤

（一）新建工程

打开 MetaFacture 软件，新建一个标准工程，设备选择 Sinsegye，编程语言可选择结构化文本（ST）。

（二）查看工智机 IP 地址

1\. 将工智机连接网线、电源、显示器、鼠标、键盘，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/67162685db3b3)

中科时代的工智机内置了Ubuntu 系统或 Windows 系统。

Windows 系统，在开始菜单栏输入 CMD 打开终端命令窗口，输入'IPconfig'。

Ubuntu 系统，在终端中输入'ifconfig'。可在显示器上查看对应网口的 IP 地址。

（三）添加Ethernet IP 设备

下载设备描述文件“Sange Elec EIP Adapter1 v1.3”，添加设备描述文件中。

选中已添加的工智机，右键【添加设备】，在弹出窗口中选择【以太网适配器】-【Ethernet】， 点击【添加设备】，如下图

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/671626865496f)

同理在添加的【Ethernet】右键【添加设备】，在弹出窗口中选择【现场总线】-【Ethernet/IP】-【Ethernet/IP 扫描器】-【Ethernet/IP scanner】，点击【添加设备】，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/67162686d2007)

添加【Ethernet/IP scanner】后，会在任务配置中自动添加如下图的设备，注意不要删除。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/671626875e4d8)

添加 Ethernet IP IO 输出模块

下载设备描述文件【Sange Elec EIP Adapter1 v1.3】，添加设备描述文件，点击【工具】-【设备存储库】，在弹窗中点击【安装】，选择文件存放的路径，点击【打开】，即添加完成。

选择上一步添加的【Ethernet/IP scanner】右键【添加设备】，【现场总线】-【Ethernet/IP】

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/67162687c92bc)

-【Ethernet/IP 远程适配器】-【serial to Ethernet/IP getaway】，如下图，点击【添加设备】。

（四）修改EIP 设备IP

1\. 该实验工智机的 IP 为 192.168.110.119，在浏览器中打开 http://192.168.110.119:8081， 点击【硬件配置】-【网口配置】-【enp1s0f1 中的设置】，该网口代表lan2 口，与 Ethernet IP 设备相连，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/671626884ecfe)

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/67162688c406d)

2\. 点击【禁用】-IPv4 方式【手动】-地址为 192.168.4.225（该网址为 Ethernet IP 设备的默认 IP），子网掩码为 255.255.255.0。

（五）安装一体式远程 IO 配置软件

该步骤仅供初次安装 EIP 设备时，需进行配置。

个人 PC 与EIP 设备用一根网线直连-&gt;使用 IO 配置软件-&gt;选择以太网卡-&gt;\[搜索设备\]-&gt;选

择设备后\[获取设备参数\]-&gt;进行 IP 配置

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/671626893d7b9.png)

注：O-&gt;T 和 T-&gt;O 配置，MetaFacture 要与该配置保持一致

（六）MetaFacture 工程基本配置

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268998d31)

\[Ethernet\]配置工智机与调试设备连接网口

如上图，【Ethernet】-【通用】，网络接口为【enp1s0f1】，IP 地址【192.168.4.225】， 子网掩码为 255.255.255.0。

\[Serial to EtherNet/IP Gateway\]配置 IP 地址在【Serial to EtherNet/IP Gateway】【-通用】【-地址设置】【-IP 地址】中，输入192.168.4.225，如下图。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268a22ee8)

在【Serial to EtherNet/IP Gateway】-【assembly 程序集】中，显示对应配置、输入、输出均与 IO 配置 exe 保持一致。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268a9dd39)

（七）变量映射

在【PLC\_PRG】中输入以下程序：

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268b140db)

（八）使能变量

如下图，在【Serial to EtherNet/IP Gateway】-【Ethernet IP IO 映射】-【使能 1】。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268b6f16d)

（九）运行程序及结果

点击【生成代码】-【登录】-【启动】。

Output 输出：

MetaFacture 输出数据给 Ethernet 设备。

在【Ethernet IP IO 映射】-【预备值】改为【true】并【写入值】（ctrl+F7），如下图所示，那么在Ethernet 设备输出 output 会亮起对应的指示灯。

![](https://resource.helplook.net/docker_production/3648ne/article/HtIgugik/6716268c4079c)

Input 输入

Ethernet 设备 Input 接入电流 MetaFacture 中 Input 显示输入状态。

在对应的 Input 接入电流，在 MetaFacture 中即可观察到对应 Input 的状态。

---

### 结论

MetaFacture 设置变量值发送给 Ethernet 设备，Ethernet 设备指示灯亮起；Ethernet 设备 Input 接入电流，MetaFacture 对应的值显示为 true，那么可以表明该工智机支持Ethernet IP 通讯。